<div class="cr-all-courses" wire:init="loadData">
    <div class="cr-page-heading">
        <div class="cr-headingbox">
            <h2>{{ __('courses::courses.all_courses') }}</h2>
            <p>{{ __('courses::courses.explore_courses') }}</p>
        </div>
        <a class="am-btn cr-btn" href="{{ route('courses.tutor.create-course') }}">
            {{ __('courses::courses.create_course') }}
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                <path d="M3.75 9H9M14.25 9H9M9 9V3.75M9 9V14.25" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </a>
    </div>
    <div class="cr-stats-arae">
        <div class="cr-stat-card">
            <div class="cr-contentbox">
                <span>{{ $counts['active'] }}</span>
                <p>{{ __('courses::courses.active_courses') }}</p>
            </div>
            <span class="cr-iconbox blue">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 512 512" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M42.1719 485.478H342.513C363.278 485.478 380.111 468.645 380.111 447.88V313.126C380.111 311.47 378.196 310.547 376.9 311.58C370.042 317.048 361.576 320.11 352.807 320.294C351.984 320.312 351.325 320.984 351.325 321.808V454.16C351.325 458.312 347.959 461.679 343.806 461.679H40.8795C36.7266 461.679 33.36 458.312 33.36 454.16V228.492C33.36 224.339 36.7266 220.972 40.8795 220.972H198.426C202.936 220.972 205.833 216.183 203.74 212.188L202.325 209.487C198.151 201.52 197.021 192.431 198.933 183.857C199.915 179.452 196.927 174.562 192.414 174.562H42.172C21.4073 174.562 4.57422 191.396 4.57422 212.16V447.88C4.57422 468.645 21.4073 485.478 42.1719 485.478ZM134.024 191.318H155.853C159.772 191.318 162.95 194.496 162.95 198.416C162.95 202.336 159.772 205.514 155.853 205.514H134.024C130.105 205.514 126.927 202.336 126.927 198.416C126.927 194.496 130.105 191.318 134.024 191.318ZM97.6758 191.318H75.8477C71.9277 191.318 68.75 194.496 68.75 198.416C68.75 202.336 71.9277 205.514 75.8477 205.514H97.6758C101.596 205.514 104.773 202.336 104.773 198.416C104.773 194.496 101.596 191.318 97.6758 191.318Z" fill="black"/>
                    <path d="M183.006 128.41L209.29 151.182C211.321 152.941 214.486 152.072 215.328 149.521C220.498 133.863 228.526 109.981 229.572 108.621C229.746 108.395 230.153 107.778 230.761 106.854C235.288 99.9804 250.984 76.1502 264.967 70.5828C266.637 74.3407 302.475 131.47 326.122 168.99C331.405 177.372 339.777 183.304 349.43 185.535L498.19 219.916C504.813 221.446 509.906 214.102 506.152 208.436L424.292 84.889C419.344 77.421 411.892 71.9653 403.278 69.5044L253.892 26.8259C247.441 24.9831 241.989 31.8687 245.262 37.7245L255.89 56.7417C248.015 62.2196 230.212 77.1608 221.995 93.1018C218.26 96.0892 196.49 112.546 183.203 122.566C181.291 124.007 181.197 126.842 183.006 128.41Z" fill="black"/>
                    <path d="M274.65 111.594L303.693 163.837C314.345 182.998 332.829 196.556 354.305 200.962L424.211 215.302C427.771 216.032 429.388 220.195 427.254 223.136L400.487 260.033C381.171 286.66 345.354 295.277 316.04 280.351C283.555 263.811 255.384 239.91 233.774 210.553L229.985 205.406C220.376 192.354 220.302 174.589 229.801 161.456L266.229 111.093C268.373 108.128 272.872 108.395 274.65 111.594Z" fill="black"/>
                    <path d="M186.504 290.312C190.922 290.278 194.476 286.669 194.442 282.251C194.408 277.833 190.799 274.279 186.381 274.313C150.972 274.585 126.938 297.822 118.729 324.093C112.859 342.875 114.92 364.174 127.291 379.802H121.75C117.332 379.802 113.75 383.384 113.75 387.802C113.75 392.221 117.332 395.802 121.75 395.802H150.071C152.205 395.802 154.251 394.949 155.753 393.433C157.256 391.917 158.09 389.863 158.07 387.729L157.809 359.338C157.769 354.92 154.154 351.371 149.736 351.412C145.318 351.453 141.77 355.067 141.81 359.485L141.927 372.199C131.512 361.142 129.036 344.751 134 328.865C140.411 308.352 158.925 290.524 186.504 290.312Z" fill="black"/>
                    <path d="M222.82 298.24C220.686 298.24 218.64 299.093 217.137 300.61C215.635 302.126 214.801 304.179 214.82 306.314L215.081 334.705C215.122 339.123 218.736 342.671 223.154 342.631C227.572 342.59 231.121 338.976 231.08 334.558L230.964 321.843C241.378 332.901 243.854 349.292 238.89 365.177C232.48 385.691 213.965 403.519 186.387 403.73C181.969 403.764 178.414 407.374 178.448 411.792C178.482 416.21 182.091 419.764 186.51 419.73C221.919 419.458 245.952 396.221 254.162 369.95C260.031 351.168 257.97 329.869 245.6 314.24H251.141C255.559 314.24 259.141 310.659 259.141 306.24C259.141 301.822 255.559 298.24 251.141 298.24H222.82Z" fill="black"/>
                </svg>
            </span>
        </div>
        <div class="cr-stat-card">
            <div class="cr-contentbox">
                <span>{{ $counts['draft'] }}</span>
                <p>{{ __('courses::courses.draft_courses') }}</p>
            </div>
            <span class="cr-iconbox red">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 512 512" fill="none">
                    <path d="M209.29 151.182L183.006 128.41C181.197 126.842 181.291 124.007 183.203 122.566C196.49 112.546 218.26 96.0892 221.995 93.1018C230.212 77.1608 248.015 62.2196 255.89 56.7417L245.262 37.7245C241.989 31.8687 247.441 24.9831 253.892 26.8259L403.278 69.5044C411.892 71.9653 419.344 77.421 424.292 84.889L506.152 208.436C509.906 214.102 504.813 221.446 498.19 219.916L349.43 185.535C339.777 183.304 331.405 177.372 326.122 168.99C302.475 131.47 266.637 74.3407 264.967 70.5828C250.984 76.1502 235.288 99.9803 230.761 106.854C230.153 107.778 229.746 108.395 229.572 108.621C228.526 109.981 220.498 133.863 215.328 149.521C214.486 152.072 211.321 152.941 209.29 151.182Z" fill="black"/>
                    <path d="M303.693 163.837L274.65 111.594C272.872 108.395 268.373 108.128 266.229 111.093L229.801 161.456C220.302 174.589 220.376 192.354 229.985 205.406L233.774 210.553C255.384 239.91 283.555 263.811 316.04 280.351C345.354 295.277 381.171 286.66 400.487 260.033L427.254 223.136C429.388 220.195 427.771 216.032 424.211 215.302L354.305 200.962C332.829 196.556 314.345 182.998 303.693 163.837Z" fill="black"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M42.1719 485.478H342.513C363.278 485.478 380.111 468.645 380.111 447.88V313.126C380.111 311.47 378.196 310.547 376.9 311.58C370.042 317.048 361.576 320.11 352.807 320.294C351.984 320.312 351.325 320.984 351.325 321.808V454.16C351.325 458.312 347.959 461.679 343.806 461.679H40.8795C36.7266 461.679 33.36 458.312 33.36 454.16V228.492C33.36 224.339 36.7266 220.972 40.8795 220.972H198.426C202.936 220.972 205.833 216.183 203.74 212.188L202.325 209.487C198.151 201.52 197.021 192.431 198.933 183.857C199.915 179.452 196.927 174.562 192.414 174.562H42.172C21.4073 174.562 4.57422 191.396 4.57422 212.16V447.88C4.57422 468.645 21.4073 485.478 42.1719 485.478ZM134.024 191.318H155.853C159.772 191.318 162.95 194.496 162.95 198.416C162.95 202.336 159.772 205.514 155.853 205.514H134.024C130.105 205.514 126.927 202.336 126.927 198.416C126.927 194.496 130.105 191.318 134.024 191.318ZM97.6758 191.318H75.8477C71.9277 191.318 68.75 194.496 68.75 198.416C68.75 202.336 71.9277 205.514 75.8477 205.514H97.6758C101.596 205.514 104.773 202.336 104.773 198.416C104.773 194.496 101.596 191.318 97.6758 191.318Z" fill="black"/>
                    <path d="M186.041 285.201C183.097 283.501 179.333 284.51 177.633 287.453L170.782 299.32C170.102 300.497 170.506 302.003 171.683 302.683L186.7 311.352C187.877 312.032 189.383 311.629 190.063 310.451L196.914 298.585C198.613 295.641 197.605 291.877 194.661 290.177L186.041 285.201Z" fill="black"/>
                    <path d="M245.477 318.417C248.876 318.417 251.632 321.172 251.632 324.572V333.525C251.632 336.925 248.876 339.68 245.477 339.68H214.541C211.142 339.68 208.386 336.925 208.386 333.525V324.572C208.386 321.172 211.142 318.417 214.541 318.417H245.477Z" fill="black"/>
                    <path d="M251.632 360.352C251.632 356.952 248.876 354.197 245.477 354.197H189.922C186.522 354.197 183.767 356.952 183.767 360.352V369.305C183.767 372.705 186.522 375.46 189.922 375.46H245.477C248.876 375.46 251.632 372.705 251.632 369.305V360.352Z" fill="black"/>
                    <path d="M251.632 395.132C251.632 391.732 248.876 388.977 245.477 388.977H165.302C161.903 388.977 159.147 391.732 159.147 395.132V404.085C159.147 407.485 161.903 410.24 165.302 410.24H245.477C248.876 410.24 251.632 407.485 251.632 404.085V395.132Z" fill="black"/>
                    <path d="M165.617 309.254C166.297 308.077 167.802 307.673 168.98 308.353L183.996 317.023C185.174 317.703 185.577 319.208 184.897 320.386L154.062 372.99C153.383 374.168 151.877 374.571 150.699 373.891L135.683 365.221C134.505 364.542 134.102 363.036 134.782 361.858L165.617 309.254Z" fill="black"/>
                    <path d="M133.242 370.81C131.797 369.975 129.957 370.791 129.605 372.423L124.612 395.554C123.997 398.404 127.398 400.368 129.559 398.41L147.095 382.521C148.332 381.4 148.119 379.399 146.673 378.564L133.242 370.81Z" fill="black"/>
                </svg>
            </span>
        </div>
        <div class="cr-stat-card">
            <div class="cr-contentbox">
                <span>{{ $counts['inactive'] }}</span>
                <p>{{ __('courses::courses.inactive_courses') }}</p>
            </div>
            <span class="cr-iconbox green">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 512 512" fill="none">
                    <path d="M209.29 151.182L183.006 128.41C181.197 126.842 181.291 124.007 183.203 122.566C196.49 112.546 218.26 96.0892 221.995 93.1018C230.212 77.1608 248.015 62.2196 255.89 56.7417L245.262 37.7245C241.989 31.8687 247.441 24.9831 253.892 26.8259L403.278 69.5044C411.892 71.9653 419.344 77.421 424.292 84.889L506.152 208.436C509.906 214.102 504.813 221.446 498.19 219.916L349.43 185.535C339.777 183.304 331.405 177.372 326.122 168.99C302.475 131.47 266.637 74.3407 264.967 70.5828C250.984 76.1502 235.288 99.9803 230.761 106.854C230.153 107.778 229.746 108.395 229.572 108.621C228.526 109.981 220.498 133.863 215.328 149.521C214.486 152.072 211.321 152.941 209.29 151.182Z" fill="black"/>
                    <path d="M303.693 163.837L274.65 111.594C272.872 108.395 268.373 108.128 266.229 111.093L229.801 161.456C220.302 174.589 220.376 192.354 229.985 205.406L233.774 210.553C255.384 239.91 283.555 263.811 316.04 280.351C345.354 295.277 381.171 286.66 400.487 260.033L427.254 223.136C429.388 220.195 427.771 216.032 424.211 215.302L354.305 200.962C332.829 196.556 314.345 182.998 303.693 163.837Z" fill="black"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M42.1719 485.478H342.513C363.278 485.478 380.111 468.645 380.111 447.88V313.126C380.111 311.47 378.196 310.547 376.9 311.58C370.042 317.048 361.576 320.11 352.807 320.294C351.984 320.312 351.325 320.984 351.325 321.808V454.16C351.325 458.312 347.959 461.679 343.806 461.679H40.8795C36.7266 461.679 33.36 458.312 33.36 454.16V228.492C33.36 224.339 36.7266 220.972 40.8795 220.972H198.426C202.936 220.972 205.833 216.183 203.74 212.188L202.325 209.487C198.151 201.52 197.021 192.431 198.933 183.857C199.915 179.452 196.927 174.562 192.414 174.562H42.172C21.4073 174.562 4.57422 191.396 4.57422 212.16V447.88C4.57422 468.645 21.4073 485.478 42.1719 485.478ZM134.024 191.318H155.853C159.772 191.318 162.95 194.496 162.95 198.416C162.95 202.336 159.772 205.514 155.853 205.514H134.024C130.105 205.514 126.927 202.336 126.927 198.416C126.927 194.496 130.105 191.318 134.024 191.318ZM97.6758 191.318H75.8477C71.9277 191.318 68.75 194.496 68.75 198.416C68.75 202.336 71.9277 205.514 75.8477 205.514H97.6758C101.596 205.514 104.773 202.336 104.773 198.416C104.773 194.496 101.596 191.318 97.6758 191.318Z" fill="black"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M186.445 266.84C142.155 266.84 106.25 302.744 106.25 347.035C106.25 369.178 115.234 389.236 129.738 403.74C144.242 418.245 164.301 427.23 186.445 427.23C230.735 427.23 266.64 391.325 266.64 347.035C266.64 324.891 257.655 304.832 243.151 290.328C228.646 275.824 208.588 266.84 186.445 266.84ZM121.25 347.035C121.25 311.029 150.439 281.84 186.445 281.84C201.749 281.84 215.812 287.106 226.937 295.935L135.345 387.527C126.516 376.402 121.25 362.338 121.25 347.035ZM145.952 398.133L237.544 306.541C246.374 317.667 251.64 331.731 251.64 347.035C251.64 383.041 222.451 412.23 186.445 412.23C171.141 412.23 157.077 406.964 145.952 398.133Z" fill="black"/>
                </svg>
            </span>
        </div>
        <div class="cr-stat-card">
            <div class="cr-contentbox">
                <span>{{ $counts['under_review'] }}</span>
                <p>{{ __('courses::courses.under_review') }}</p>
            </div>
            <span class="cr-iconbox purple">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 512 513" fill="none">
                    <path d="M209.29 151.955L183.006 129.183C181.197 127.616 181.291 124.781 183.203 123.34C196.49 113.32 218.26 96.8627 221.995 93.8752C230.212 77.9343 248.015 62.9931 255.89 57.5151L245.262 38.498C241.989 32.6421 247.441 25.7566 253.892 27.5993L403.278 70.2778C411.892 72.7387 419.344 78.1945 424.292 85.6624L506.152 209.209C509.906 214.876 504.813 222.22 498.19 220.689L349.43 186.308C339.777 184.077 331.405 178.145 326.122 169.764C302.475 132.243 266.637 75.1141 264.967 71.3563C250.984 76.9237 235.288 100.754 230.761 107.628C230.153 108.551 229.746 109.169 229.572 109.395C228.526 110.754 220.498 134.636 215.328 150.294C214.486 152.845 211.321 153.714 209.29 151.955Z" fill="black"/>
                    <path d="M303.693 164.61L274.65 112.367C272.872 109.169 268.373 108.901 266.229 111.866L229.801 162.23C220.302 175.362 220.376 193.127 229.985 206.18L233.774 211.327C255.384 240.683 283.555 264.585 316.04 281.125C345.354 296.051 381.171 287.433 400.487 260.806L427.254 223.909C429.388 220.968 427.771 216.805 424.211 216.075L354.305 201.735C332.829 197.33 314.345 183.771 303.693 164.61Z" fill="black"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M42.1719 486.252H342.513C363.278 486.252 380.111 469.419 380.111 448.654V313.9C380.111 312.243 378.196 311.321 376.9 312.353C370.042 317.821 361.576 320.883 352.807 321.068C351.984 321.085 351.325 321.758 351.325 322.581V454.933C351.325 459.086 347.959 462.453 343.806 462.453H40.8795C36.7266 462.453 33.36 459.086 33.36 454.933V229.265C33.36 225.112 36.7266 221.746 40.8795 221.746H198.426C202.936 221.746 205.833 216.956 203.74 212.961L202.325 210.26C198.151 202.294 197.021 193.204 198.933 184.63C199.915 180.226 196.927 175.336 192.414 175.336H42.172C21.4073 175.336 4.57422 192.169 4.57422 212.934V448.654C4.57422 469.419 21.4073 486.252 42.1719 486.252ZM134.024 192.092H155.853C159.772 192.092 162.95 195.27 162.95 199.189C162.95 203.109 159.772 206.287 155.853 206.287H134.024C130.105 206.287 126.927 203.109 126.927 199.189C126.927 195.27 130.105 192.092 134.024 192.092ZM97.6758 192.092H75.8477C71.9277 192.092 68.75 195.27 68.75 199.189C68.75 203.109 71.9277 206.287 75.8477 206.287H97.6758C101.596 206.287 104.773 203.109 104.773 199.189C104.773 195.27 101.596 192.092 97.6758 192.092Z" fill="black"/>
                    <path d="M196.833 322.168C193.519 322.168 190.833 324.854 190.833 328.168C190.833 331.482 193.519 334.168 196.833 334.168H221.022C224.336 334.168 227.022 331.482 227.022 328.168C227.022 324.854 224.336 322.168 221.022 322.168H196.833Z" fill="black"/>
                    <path d="M178.82 333.733C181.134 331.361 181.087 327.562 178.715 325.248C176.343 322.934 172.544 322.981 170.23 325.354L159.765 336.082L157.026 333.343C154.683 331 150.884 331 148.541 333.343C146.198 335.686 146.198 339.485 148.541 341.828L155.576 348.863C156.71 349.997 158.251 350.63 159.856 350.62C161.46 350.61 162.993 349.958 164.113 348.81L178.82 333.733Z" fill="black"/>
                    <path d="M196.833 341.116C193.519 341.116 190.833 343.802 190.833 347.116C190.833 350.43 193.519 353.116 196.833 353.116H205.154C208.468 353.116 211.154 350.43 211.154 347.116C211.154 343.802 208.468 341.116 205.154 341.116H196.833Z" fill="black"/>
                    <path d="M159.196 374.738C156.853 372.395 153.054 372.395 150.711 374.738C148.367 377.081 148.367 380.88 150.711 383.223L154.508 387.02L150.711 390.817C148.367 393.16 148.367 396.959 150.711 399.303C153.054 401.646 156.853 401.646 159.196 399.303L162.993 395.506L166.79 399.303C169.133 401.646 172.932 401.646 175.275 399.303C177.618 396.959 177.618 393.16 175.275 390.817L171.478 387.02L175.275 383.223C177.618 380.88 177.618 377.081 175.275 374.738C172.932 372.395 169.133 372.395 166.79 374.738L162.993 378.535L159.196 374.738Z" fill="black"/>
                    <path d="M196.833 384.981H221.022C224.336 384.981 227.022 382.294 227.022 378.981C227.022 375.667 224.336 372.981 221.022 372.981H196.833C193.519 372.981 190.833 375.667 190.833 378.981C190.833 382.294 193.519 384.981 196.833 384.981Z" fill="black"/>
                    <path d="M196.833 391.929C193.519 391.929 190.833 394.615 190.833 397.929C190.833 401.242 193.519 403.929 196.833 403.929H205.154C208.468 403.929 211.154 401.242 211.154 397.929C211.154 394.615 208.468 391.929 205.154 391.929H196.833Z" fill="black"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M173.858 262.264C164.822 262.264 157.193 268.291 154.774 276.545C138.626 279.012 124.74 292.702 124.74 309.917V399.225C124.74 417.875 139.859 432.994 158.509 432.994H218.047C236.697 432.994 251.816 417.875 251.816 399.225V309.917C251.816 293.409 240.945 279.086 224.712 276.547C222.293 268.292 214.664 262.264 205.627 262.264H173.858ZM136.74 309.917C136.74 299.849 144.835 290.902 155.07 288.677C157.772 296.452 165.163 302.033 173.858 302.033H205.627C214.304 302.033 221.682 296.476 224.398 288.726C233.474 290.939 239.816 299.281 239.816 309.917V399.225C239.816 411.247 230.07 420.994 218.047 420.994H158.509C146.486 420.994 136.74 411.247 136.74 399.225V309.917ZM165.974 282.148C165.974 277.794 169.504 274.264 173.858 274.264H205.627C209.982 274.264 213.512 277.794 213.512 282.148C213.512 286.503 209.982 290.033 205.627 290.033H173.858C169.504 290.033 165.974 286.503 165.974 282.148Z" fill="black"/>
                </svg>
            </span>
        </div>
        <div class="cr-stat-card">
            <div class="cr-contentbox">
                <span>{{ $counts['need_revision'] }}</span>
                <p>{{ __('courses::courses.needs_revision') }}</p>
            </div>
            <span class="cr-iconbox yellow">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 512 512" fill="none">
                    <path d="M209.29 151.182L183.006 128.41C181.197 126.842 181.291 124.007 183.203 122.566C196.49 112.546 218.26 96.0892 221.995 93.1018C230.212 77.1608 248.015 62.2196 255.89 56.7417L245.262 37.7245C241.989 31.8687 247.441 24.9831 253.892 26.8259L403.278 69.5044C411.892 71.9653 419.344 77.421 424.292 84.889L506.152 208.436C509.906 214.102 504.813 221.446 498.19 219.916L349.43 185.535C339.777 183.304 331.405 177.372 326.122 168.99C302.475 131.47 266.637 74.3407 264.967 70.5828C250.984 76.1502 235.288 99.9803 230.761 106.854C230.153 107.778 229.746 108.395 229.572 108.621C228.526 109.981 220.498 133.863 215.328 149.521C214.486 152.072 211.321 152.941 209.29 151.182Z" fill="black"/>
                    <path d="M303.693 163.837L274.65 111.594C272.872 108.395 268.373 108.128 266.229 111.093L229.801 161.456C220.302 174.589 220.376 192.354 229.985 205.406L233.774 210.553C255.384 239.91 283.555 263.811 316.04 280.351C345.354 295.277 381.171 286.66 400.487 260.033L427.254 223.136C429.388 220.195 427.771 216.032 424.211 215.302L354.305 200.962C332.829 196.556 314.345 182.998 303.693 163.837Z" fill="black"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M42.1719 485.478H342.513C363.278 485.478 380.111 468.645 380.111 447.88V313.126C380.111 311.47 378.196 310.547 376.9 311.58C370.042 317.048 361.576 320.11 352.807 320.294C351.984 320.312 351.325 320.984 351.325 321.808V454.16C351.325 458.312 347.959 461.679 343.806 461.679H40.8795C36.7266 461.679 33.36 458.312 33.36 454.16V228.492C33.36 224.339 36.7266 220.972 40.8795 220.972H198.426C202.936 220.972 205.833 216.183 203.74 212.188L202.325 209.487C198.151 201.52 197.021 192.431 198.933 183.857C199.915 179.452 196.927 174.562 192.414 174.562H42.172C21.4073 174.562 4.57422 191.396 4.57422 212.16V447.88C4.57422 468.645 21.4073 485.478 42.1719 485.478ZM134.024 191.318H155.853C159.772 191.318 162.95 194.496 162.95 198.416C162.95 202.336 159.772 205.514 155.853 205.514H134.024C130.105 205.514 126.927 202.336 126.927 198.416C126.927 194.496 130.105 191.318 134.024 191.318ZM97.6758 191.318H75.8477C71.9277 191.318 68.75 194.496 68.75 198.416C68.75 202.336 71.9277 205.514 75.8477 205.514H97.6758C101.596 205.514 104.773 202.336 104.773 198.416C104.773 194.496 101.596 191.318 97.6758 191.318Z" fill="black"/>
                    <path d="M256.723 277.935C256.723 273.923 253.471 270.672 249.46 270.672C245.449 270.672 242.197 273.923 242.197 277.935V292.615C228.639 279.805 210.343 271.943 190.206 271.943C148.385 271.943 114.483 305.848 114.483 347.671C114.483 389.494 148.385 423.399 190.206 423.399C221.607 423.399 248.526 404.286 260.001 377.089C261.56 373.393 259.828 369.133 256.133 367.574C252.437 366.015 248.177 367.747 246.618 371.442C237.333 393.45 215.562 408.873 190.206 408.873C156.408 408.873 129.008 381.473 129.008 347.671C129.008 313.869 156.408 286.468 190.206 286.468C207.915 286.468 223.872 293.988 235.053 306.026H214.108C210.097 306.026 206.846 309.277 206.846 313.288C206.846 317.3 210.097 320.551 214.108 320.551H249.46C253.471 320.551 256.723 317.3 256.723 313.288V277.935Z" fill="black"/>
                </svg>
            </span>
        </div>
    </div>

    <div class="cr-filter-area">
        <div class="at-form-group">
            <input type="text" class="at-form-control" placeholder="{{ __('courses::courses.search_by_keyword') }}" wire:model.live.debounce.500ms='filters.keyword'>
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                <path d="M13.9997 14L11.5756 11.576M11.5756 11.576C12.6614 10.4902 13.333 8.99023 13.333 7.33337C13.333 4.01967 10.6467 1.33337 7.33301 1.33337C4.0193 1.33337 1.33301 4.01967 1.33301 7.33337C1.33301 10.6471 4.0193 13.3334 7.33301 13.3334C8.98986 13.3334 10.4899 12.6618 11.5756 11.576Z" stroke="#585858" stroke-width="1.5" stroke-linecap="round"/>
            </svg>
        </div>
        <div class="cr-filters">
            @if ($showClearFilters)
                <span class="cr-clear-filter" wire:click="resetFilters">{{ __('courses::courses.clear_all_filters') }}
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                        <g opacity="0.7">
                        <path d="M3.5 10.5L10.5 3.5M3.5 3.5L10.5 10.5" stroke="#585858" stroke-width="1.3125" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </svg>
                </span>
            @endif
            <div class="at-form-group" wire:ignore>
                <select class="am-select2" data-componentid="@this" id="sort-select" data-live="true" data-searchable="false" data-wiremodel="filters.sort">
                    <option value="desc">{{ __('courses::courses.newest_first') }}</option>
                    <option value="asc">{{ __('courses::courses.oldest_first') }}</option>
                </select>
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M4 6L8 10L12 6" stroke="#585858" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="at-form-group" wire:ignore>
                <select class="am-select2"  data-componentid="@this" id="category-select" data-live="true" data-searchable="true" data-wiremodel="filters.category_id">
                    <option value="">{{ __('courses::courses.select_a_category') }}</option>
                    @if (!empty($categories))
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    @endif
                </select>
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M4 6L8 10L12 6" stroke="#585858" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="at-form-group cr-price-dropdown" wire:ignore>
                <span>{{ __('courses::courses.price_range') }}
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M4 6L8 10L12 6" stroke="#585858" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                </span>
                <div class="cr-price-range" style="display: none;">
                    <div class="form-group ">
                        <label class="am-important" for="course-title">{{ __('courses::courses.price_range') }}</label>
                        <div class="form-group-two-wrap">
                            <input class="form-control" type="number" id="cr_min_price" placeholder="{{ __('courses::courses.min_price') }}">
                            <input class="form-control" type="number" id="cr_max_price" placeholder="{{ __('courses::courses.max_price') }}">
                        </div>
                        <div id="sliderrange" class="cr-slider-range"></div>
                    </div>
                </div>
            </div>
            <div class="at-form-group" wire:ignore>
                <select class="am-select2"  data-componentid="@this" id="status-select" data-live="true" data-searchable="false" data-wiremodel="filters.status">
                    <option value="">{{ __('courses::courses.select_status') }}</option>
                    @if (!empty($statuses))
                        @foreach ($statuses as $status => $key)
                            <option value="{{ $status }}">{{ __('courses::courses.'. $status) }}</option>
                        @endforeach
                    @endif
                </select>
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M4 6L8 10L12 6" stroke="#585858" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
        </div>
    </div>
    <div class="am-table-area">
        <div class="am-courses-table">
            <table class="am-table">
                <thead>
                    <tr>
                        <th>{{ __('courses::courses.course_title') }}</th>
                        <th>{{ __('courses::courses.category') }}</th>
                        <th>{{ __('courses::courses.price') }}</th>
                        <th>{{ __('courses::courses.enrolled_students') }}</th>
                        <th>{{ __('courses::courses.status') }}</th>
                    </tr>
                </thead>
                @if (!$isLoading)
                    <tbody wire:loading.block>
                        @include('courses::skeletons.courses-listing')
                    </tbody>

                    <tbody wire:loading.remove.block>
                        @if (!empty($courses) && $courses->isNotEmpty())
                            @foreach ($courses as $course)
                                <tr wire:key="{{ $course->id }}">
                                    <td>
                                        <div class="cr-image-and-text">
                                            <figure>
                                                @if (!empty($course->thumbnail?->path))
                                                    <img src="{{ url(Storage::url($course->thumbnail?->path)) }}" alt="{{ $course->title }}">
                                                @else
                                                    <img src="{{ asset('modules/courses/images/course.png') }}" alt="{{ $course->title }}">
                                                @endif
                                            </figure>
                                            {{ html_entity_decode($course->title) }}
                                        </div>
                                    </td>
                                    <td>{{ $course->category?->name }}</td>
                                    <td>{{ !empty($course->pricing?->final_price)? formatAmount($course->pricing?->final_price) : __('courses::courses.free') }}</td>
                                    <td>
                                        <div class="student-list">
                                            @if(!empty($course->enrollments) && $course->enrollments->isNotEmpty())
                                                <div class="cr-avatar-group">
                                                    @foreach ($course->enrollments->take(5) as $enrollment)
                                                        <div class="cr-avatar">
                                                            <img src="{{ asset('storage/'. $enrollment->student?->image) }}" alt="student-1">
                                                        </div>
                                                    @endforeach
                                                </div>
                                                <span>
                                                    @if($course->enrollments_count == 1)
                                                        {{ __('courses::courses.total_enrolled_student') }}
                                                    @else
                                                        {{ __('courses::courses.total_enrolled_students', ['count' => $course->enrollments_count]) }} 
                                                    @endif
                                                </span>
                                            @else
                                                <span>
                                                    {{ __('courses::courses.no_enrolled_students') }}
                                                </span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="cr-status-wrap">
                                            <span class="cr-status">
                                                <span style="background-color: {{ $course->status_color ?? '#008000' }};" class="cr-dot active"></span>
                                                {{ __('courses::courses.' . $course->status) }}
                                            </span>
                                            <div class="am-itemdropdown">
                                                <a href="javascript:void(0);" id="am-itemdropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i>
                                                        <svg  width="14" height="14" viewBox="0 0 14 14" fill="none">
                                                            <path d="M2.62484 5.54166C1.82275 5.54166 1.1665 6.19791 1.1665 6.99999C1.1665 7.80207 1.82275 8.45832 2.62484 8.45832C3.42692 8.45832 4.08317 7.80207 4.08317 6.99999C4.08317 6.19791 3.42692 5.54166 2.62484 5.54166Z" fill="#585858" />
                                                            <path d="M11.3748 5.54166C10.5728 5.54166 9.9165 6.19791 9.9165 6.99999C9.9165 7.80207 10.5728 8.45832 11.3748 8.45832C12.1769 8.45832 12.8332 7.80207 12.8332 6.99999C12.8332 6.19791 12.1769 5.54166 11.3748 5.54166Z" fill="#585858" />
                                                            <path d="M5.5415 6.99999C5.5415 6.19791 6.19775 5.54166 6.99984 5.54166C7.80192 5.54166 8.45817 6.19791 8.45817 6.99999C8.45817 7.80207 7.80192 8.45832 6.99984 8.45832C6.19775 8.45832 5.5415 7.80207 5.5415 6.99999Z" fill="#585858" />
                                                        </svg>
                                                    </i>
                                                </a>
                                                <ul class="am-itemdropdown_list dropdown-menu" aria-labelledby="dropdownMenuLink">
                                                    <li>
                                                        <a href="{{ route('courses.course-detail', ['slug' => $course->slug]) }}" target="_blank">
                                                            <i class="am-icon-eye-open-01"></i>
                                                            {{ __('courses::courses.view_details') }}
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="{{ route('courses.course-taking', ['slug' => $course->slug]) }}" target="_blank">
                                                            <i class="am-icon-book-1"></i>
                                                            {{ __('courses::courses.course_page') }}
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="{{ route('courses.tutor.edit-course', ['tab' => 'details', 'id' => $course->id]) }}">
                                                            <i class="am-icon-pencil-02"></i>
                                                            {{ __('courses::courses.edit') }}
                                                        </a>
                                                    </li>
                                                    <li> 
                                                        @if( $course->featured)
                                                            <a href="javascript:void(0);" wire:click.prevent="toggleFeatured({{ $course->id }})">
                                                                <i class="am-icon-heart-02"></i>
                                                                {{__('courses::courses.unfeature')}}
                                                            </a>
                                                        @else
                                                        <a href="javascript:void(0);" wire:click.prevent="toggleFeatured({{ $course->id }})">
                                                                <i class="am-icon-heart-filled-1"></i>
                                                                {{ __('courses::courses.feature') }}
                                                            </a>
                                                        @endif
                                                    </li>
                                                    <li>
                                                        <a href="javascript:void(0);" @click="$wire.dispatch('showConfirm', { id : {{ $course->id }}, action : 'delete-course' })">
                                                            <i class="am-icon-trash-02"></i>
                                                            {{ __('courses::courses.delete') }}
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr class="cr-courses-emptycase">
                                <td>
                                    @if ($showClearFilters)
                                        <div class="cr-no-record-container">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="44" height="59" viewBox="0 0 44 59" fill="none">
                                                    <path d="M37.3989 15.2008C39.829 15.2008 41.7989 17.1708 41.7989 19.6008V48.2001C41.7989 53.0602 37.859 57 32.999 57H10.9991C6.13907 57 2.19922 53.0602 2.19922 48.2001V10.801C2.19922 5.94094 6.13906 2.0011 10.9991 2.0011H24.1991C26.6291 2.0011 28.599 3.97102 28.599 6.40103V10.8009C28.599 13.2309 30.5689 15.2008 32.9989 15.2008H37.3989Z" stroke="#EAEAEA" stroke-width="3.29995" stroke-miterlimit="10"/>
                                                    <path d="M21.5098 2H25.0226C27.3126 2 29.5125 2.89274 31.1549 4.48862L39.1261 12.2338C40.8314 13.8908 41.7936 16.1674 41.7936 18.5451V26.2655" stroke="#EAEAEA" stroke-width="3.29995" stroke-miterlimit="10"/>
                                                    <path d="M20.3468 43.7979C26.7256 43.7979 31.8967 38.6269 31.8967 32.2481C31.8967 25.8694 26.7256 20.6984 20.3468 20.6984C13.9679 20.6984 8.79688 25.8694 8.79688 32.2481C8.79688 38.6269 13.9679 43.7979 20.3468 43.7979Z" stroke="#EAEAEA" stroke-width="2.47496" stroke-miterlimit="10"/>
                                                    <path d="M18.5657 30.8639C18.0813 31.6925 17.1816 32.2522 16.1574 32.2522C15.124 32.2522 14.2274 31.6925 13.7461 30.8639" stroke="#EAEAEA" stroke-width="2.09005" stroke-miterlimit="10" stroke-linecap="round"/>
                                                    <path d="M26.949 30.8641C26.4658 31.6976 25.5634 32.2613 24.5356 32.2613C23.4985 32.2613 22.5992 31.6976 22.1191 30.8641" stroke="#EAEAEA" stroke-width="2.09005" stroke-miterlimit="10" stroke-linecap="round"/>
                                                    <path d="M20.3906 36.9304H20.4035" stroke="#EAEAEA" stroke-width="2.78674" stroke-linecap="round"/>
                                                    <path d="M35.1906 47.0972L31.8906 43.7972" stroke="#EAEAEA" stroke-width="2.47496" stroke-miterlimit="10" stroke-linecap="round"/>
                                                </svg>
                                            </span>
                                            <h6>{{ __('courses::courses.empty_view_heading') }}!</h6>
                                            <p>{{ __('courses::courses.empty_view_description') }}</p>
                                        </div>
                                    @else
                                        <div class="cr-no-record-container">
                                            <figure>
                                                <img src="{{ asset('modules/courses/images/empty-view.png') }}" alt="{{ __('courses::courses.empty_view') }}">
                                            </figure>
                                            <h6>{{ __('courses::courses.no_records_added_yet') }}</h6>
                                            <p>{{ __('courses::courses.create_engaging_courses') }}</p>
                                            <a href="{{ route('courses.tutor.create-course') }}">
                                            <button type="button" wire:click="addMoreFaq" class="am-btn">
                                                {{ __('courses::courses.create_course') }}
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                                    <path d="M3.75 9H9M14.25 9H9M9 9V3.75M9 9V14.25" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>
                                                </button>
                                            </a>
                                        </div>
                                    @endif
                                </td>
                            </tr>
                        @endif
                    </tbody>
                @else
                    <tbody>
                        @include('courses::skeletons.courses-listing')
                    </tbody>
                @endif
            </table>
        </div>
        @if (!$isLoading && $courses->links()->paginator->hasPages())
            <div class="am-pagination">
                @if (!empty($parPageList))
                    <div class="am-pagination-filter" wire:ignore>
                        <em>{{ __('courses::courses.show') }}</em>
                        <span class="am-select">
                            <select x-init="$wire.dispatch('initSelect2', {target: '#per-page-select'});" class="am-select2" id="per-page-select" data-componentid="@this" data-live="true" data-searchable="false" data-wiremodel="perPage">
                                @if (!empty($perPage) && !in_array($this->perPage, $this->parPageList))
                                    <option value="{{ $perPage }}">{{ $perPage }}</option>
                                @endif
                                @foreach (perPageOpt() as $option)
                                    <option {{ $perPage == $option ? 'selected' : '' }} value="{{ $option }}">{{ $option }}</option>
                                @endforeach
                            </select>
                        </span>
                        <em>{{ __('courses::courses.listings_per_page') }}</em>
                    </div>
                @endif
                {{ $courses->links('courses::pagination.pagination', ['perPageOptions' => $perPageOptions]) }}
            </div>
        @endif
    </div>
    <div class="modal fade cr-course-del-modal " id="delete-modal" tabindex="-1" aria-labelledby="delete-modalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-body">
                    <span class="cr-close" data-bs-dismiss="modal" aria-label="Close">
                        <svg  width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <g opacity="0.7">
                                <path d="M4 12L12 4M4 4L12 12" stroke="#585858" stroke-linecap="round" stroke-linejoin="round"/>
                            </g>
                        </svg>
                    </span>
                    <figure class="cr-delete-icon">
                        <svg width="30" height="30" viewBox="0 0 30 30" fill="none">
                            <path d="M5 6.25L5.80705 19.9698C5.96296 22.6203 6.04091 23.9455 6.6066 24.9512C7.10457 25.8366 7.86039 26.5492 8.77345 26.9944C9.81064 27.5 11.1382 27.5 13.7932 27.5H16.2068C18.8618 27.5 20.1894 27.5 21.2266 26.9944C22.1396 26.5492 22.8954 25.8366 23.3934 24.9512C23.9591 23.9455 24.037 22.6203 24.193 19.9698L25 6.25M5 6.25H2.5M5 6.25H25M25 6.25H27.5M20 6.25L19.4338 4.55132C19.1879 3.81367 19.065 3.44485 18.8369 3.17217C18.6356 2.93138 18.377 2.74499 18.0848 2.6301C17.754 2.5 17.3653 2.5 16.5877 2.5H13.4123C12.6347 2.5 12.246 2.5 11.9152 2.6301C11.623 2.74499 11.3644 2.93138 11.1631 3.17217C10.935 3.44485 10.8121 3.81367 10.5662 4.55132L10 6.25M12.5 12.5V21.25M17.5 12.5V17.5" stroke="#F04438" stroke-width="1.875" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </figure>
                    <div class="cr-delete-content">
                        <h3>{{ __('courses::courses.confirm') }}!</h3>
                        <p>{{ __('courses::courses.remove_confirmation') }}</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="am-white-btn" data-bs-dismiss="modal">{{ __('courses::courses.no') }}</button>
                    <button type="button" class="am-btn cr-del-btn">{{ __('courses::courses.yes') }}</button>
                </div>
            </div>
        </div>
    </div>
</div>
@push('styles')
    <link rel="stylesheet" href="{{ asset('modules/courses/css/main.css') }}">
    <link rel="stylesheet" href="{{ asset('modules/courses/css/nouislider.min.css') }}">
@endpush
@push('scripts')
<script defer src="{{ asset('modules/courses/js/nouislider.min.js')}}"></script>
    <script type="text/javascript" data-navigate-once>
        var component = '';
        var slider = '';
        document.addEventListener('livewire:navigated', function() {
            component = @this;
        },{ once: true });

        document.addEventListener('loadPageJs', (event) => {
            setTimeout(function() {
                initPriceRange();
            }, 50);
        });

        document.addEventListener('resetFilters', (event) => {
            resetFilters();
        });

        function resetFilters() {
            slider.noUiSlider.reset();
            $('#category-select').val('').trigger('change.select2');
            $('#sort-select').val('desc').trigger('change.select2');
            $('#status-select').val('').trigger('change.select2');
        }

        function initPriceRange() {
            slider = document.getElementById('sliderrange');
            if (slider) {
                noUiSlider.create(slider, {
                    start: [0, 1000],
                    connect: true,
                    range: {
                        'min': 0,
                        'max': 1000
                    }
                });

                var minPriceInput = document.getElementById('cr_min_price');
                var maxPriceInput = document.getElementById('cr_max_price');

                slider.noUiSlider.on('update', function (values, handle) {
                    var value = values[handle];
                    if (handle) {
                        maxPriceInput.value = Math.round(value);
                    } else {
                        minPriceInput.value = Math.round(value);
                    }
                });

                slider.noUiSlider.on('change', function (values, handle) {
                    var minValue = Math.round(values[0]);
                    var maxValue = Math.round(values[1]);
                    component.set('filters.min_price', minValue);
                    component.set('filters.max_price', maxValue);
                });

                minPriceInput.addEventListener('change', function () {
                    slider.noUiSlider.set([this.value, null]);
                });

                maxPriceInput.addEventListener('change', function () {
                    slider.noUiSlider.set([null, this.value]);
                });
            }
        }
        document.addEventListener('DOMContentLoaded', function( ) {
            jQuery(document).ready(function() {
                jQuery('.cr-price-dropdown').on('click', function(event) {
                    event.stopPropagation();
                    jQuery('.cr-price-range').toggle();
                });

                jQuery('.cr-price-range *').on('click', function(event) {
                    event.stopPropagation();
                });
            

                jQuery(document).on('click', function(event) {
                    if (!jQuery(event.target).closest('.cr-price-range').length && !jQuery(event.target).hasClass('cr-price-dropdown')) {
                        jQuery('.cr-price-range').hide();
                    }
                });
                
                $(document).on('change', '#cr_min_price, #cr_max_price', function(event){

                    let minValue = $('#cr_min_price').val();
                    let maxValue = $('#cr_max_price').val();
                    @this.set('filters.min_price', minValue);
                    @this.set('filters.max_price', maxValue);
                });
            });
        });

    </script>
 @endpush
