<?php

namespace Modules\Courses\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Promotion extends Model
{
    use HasFactory;

    protected $table;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('courses.db_prefix') . 'promotions';
    }

    protected $fillable = [
        'code',
        'description',
        'valid_from',
        'valid_to',
        'color',
        'discount_percentage',
        'maximum_users',
    ];

    /**
     * Get the table associated with the model.
     *
     * @return string
     */
    public function getTable()
    {
        return config('courses.db_prefix') . 'promotions';
    }
}
