<?php

namespace Modules\Courses\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;


class Faq extends Model
{
    use HasFactory;

    protected $fillable = ['question', 'answer'];

    protected $table;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('courses.db_prefix') . 'faqs';
    }

    /**
     * Get the table associated with the model.
     *
     * @return string
     */
    public function getTable()
    {
        return config('courses.db_prefix') . 'faqs';
    }
}
