<?php

namespace Modules\Courses\Models;

use Modules\Courses\Models\Like;
use App\Models\User;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class DiscussionForum extends Model
{
    use HasFactory;

    protected $table;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('courses.db_prefix') . 'discussion_forums';
    }

    protected $fillable = [
        'description',
        'course_id',
        'parent_id',
        'created_by',
    ];

    /**
     * Get the table associated with the model.
     *
     * @return string
     */
    public function getTable()
    {
        return config('courses.db_prefix') . 'discussion_forums';
    }

    public function likes(): MorphMany
    {
        return $this->morphMany(Like::class, 'likeable');
    }

    public function replies(): HasMany
    {
        return $this->hasMany(DiscussionForum::class, 'parent_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by', );
    }
}
