<?php

namespace Modules\Courses\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Facades\Auth;

class Curriculum extends Model
{
    protected $table;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('courses.db_prefix') . 'curriculums';
    }

    protected $fillable = [
        'section_id',
        'title',
        'description',
        'type',
        'media_path',
        'thumbnail',
        'article_content',
        'content_length',
        'sort_order',
        'is_preview',
    ];

    protected $casts = [
        'type' => 'string',
        'is_preview' => 'boolean',
    ];

    /**
     * Get the section that owns the curriculum.
     */
    public function section(): BelongsTo
    {
        return $this->belongsTo(Section::class);
    }

    /**
     * Get the table associated with the model.
     *
     * @return string
     */
    public function getTable()
    {
        return config('courses.db_prefix') . 'curriculums';
    }

    public function watchtime(): HasOne
    {
        return $this->hasOne(Watchtime::class)
            ->where('user_id', Auth::id());
    }
}
